/*
 * Decompiled with CFR 0.152.
 */
package xerocertgeneratorjava;

import ipworksssl.Certmgr;
import ipworksssl.IPWorksSSLException;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import xerocertgeneratorjava.CERFilter;
import xerocertgeneratorjava.PFXFilter;

public class CertificateGeneratorUI
extends JFrame {
    private static int serialNumber;
    String certSubject = "";
    boolean needComma;
    private JFileChooser fileChooser1;
    private JFileChooser fileChooser_pfx;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JInternalFrame jInternalFrame1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPasswordField jPasswordField1;
    private JTextField jTextField1;
    private JTextField jTextField10;
    private JTextField jTextField11;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;
    private JTextField jTextField7;
    private JTextField jTextField8;

    public CertificateGeneratorUI() {
        this.initComponents();
        serialNumber = Integer.parseInt(new SimpleDateFormat("yyMM").format(Calendar.getInstance().getTime()));
        this.jTextField5.setText(Integer.toString(serialNumber));
    }

    void BuildSubjectString() {
        this.certSubject = "";
        this.needComma = false;
        this.BuildSubjectPart("CN=", this.jTextField1.getText());
        this.BuildSubjectPart("E=", this.jTextField2.getText());
        this.BuildSubjectPart("OU=", this.jTextField3.getText());
        this.BuildSubjectPart("O=", this.jTextField4.getText());
        this.BuildSubjectPart("L=", this.jTextField6.getText());
        this.BuildSubjectPart("C=", this.jTextField7.getText());
        this.BuildSubjectPart("S=", this.jTextField8.getText());
    }

    void BuildSubjectPart(String subjectLabel, String subjectName) {
        if (subjectName != null && subjectName.length() > 0) {
            if (this.needComma) {
                this.certSubject = this.certSubject + ", " + subjectLabel + subjectName;
            } else {
                this.certSubject = this.certSubject + subjectLabel + subjectName;
                this.needComma = true;
            }
        }
    }

    Boolean CheckFields() {
        int subjectLength = (this.jTextField1.getText() + this.jTextField4.getText()).length();
        if (subjectLength <= 0 || String.valueOf(this.jPasswordField1.getPassword()).length() <= 0 || this.jTextField10.getText().length() <= 0 || this.jTextField11.getText().length() <= 0 || this.jTextField5.getText().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Either the Common Name or the Organization fields of the Subject section must be specified, as well as all of the fields in the FilePath section.");
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.jInternalFrame1 = new JInternalFrame();
        this.fileChooser1 = new JFileChooser();
        this.fileChooser_pfx = new JFileChooser();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jTextField4 = new JTextField();
        this.jTextField6 = new JTextField();
        this.jTextField7 = new JTextField();
        this.jTextField8 = new JTextField();
        this.jTextField1 = new JTextField();
        this.jTextField3 = new JTextField();
        this.jLabel6 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jTextField10 = new JTextField();
        this.jTextField11 = new JTextField();
        this.jTextField5 = new JTextField();
        this.jLabel11 = new JLabel();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jPasswordField1 = new JPasswordField();
        this.jInternalFrame1.setVisible(true);
        GroupLayout jInternalFrame1Layout = new GroupLayout(this.jInternalFrame1.getContentPane());
        this.jInternalFrame1.getContentPane().setLayout(jInternalFrame1Layout);
        jInternalFrame1Layout.setHorizontalGroup(jInternalFrame1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jInternalFrame1Layout.setVerticalGroup(jInternalFrame1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.fileChooser1.setAcceptAllFileFilterUsed(false);
        this.fileChooser1.setDialogType(1);
        this.fileChooser1.setApproveButtonText("Save");
        this.fileChooser1.setApproveButtonToolTipText("Select pathfile to save public key");
        this.fileChooser1.setDialogTitle("Save Public Key To...");
        this.fileChooser1.setFileFilter(new CERFilter());
        this.fileChooser_pfx.setDialogType(1);
        this.fileChooser_pfx.setApproveButtonText("Save");
        this.fileChooser_pfx.setApproveButtonToolTipText("Select the filepath to save private key");
        this.fileChooser_pfx.setDialogTitle("Save Private Key To...");
        this.fileChooser_pfx.setFileFilter(new PFXFilter());
        this.setDefaultCloseOperation(3);
        this.setTitle("Xero Certification Generator");
        this.setLocation(new Point(400, 200));
        this.jLabel1.setText("<html><body style='width: 420px'>To generate a new certificate, first fill out the fields for your Subject. Not all fields are required. Next, specify the filepaths for your public and private keys. Create a password, and then finally, click 'Create Certificate.' ");
        this.jLabel1.setToolTipText("");
        this.jButton1.setText("Create Certificate");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertificateGeneratorUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Subject"));
        this.jLabel3.setText("Common Name:");
        this.jLabel4.setText("Email Address:");
        this.jLabel5.setText("Organization:");
        this.jLabel5.setToolTipText("");
        this.jLabel7.setText("Country:");
        this.jLabel9.setText("State/Province:");
        this.jLabel10.setText("City/Locality:");
        this.jTextField2.setToolTipText("The email address of the certificate administrator.");
        this.jTextField4.setToolTipText("Legal name of your organization.");
        this.jTextField4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertificateGeneratorUI.this.jTextField4ActionPerformed(evt);
            }
        });
        this.jTextField6.setToolTipText("The city where the organization resides.");
        this.jTextField7.setToolTipText("The X.500 two letter country/region code for the country where the organization resides (US = United States, CA = Canada, etc.).");
        this.jTextField8.setToolTipText("The state or province where the organization resides.");
        this.jTextField1.setToolTipText("Fully qualified hostname of the server (used in receiving URL) or full name of person administrating certificate.");
        this.jTextField3.setToolTipText("Used to identify a specific division in your orgnization.");
        this.jLabel6.setText("Organizational Unit:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel10)).addGap(30, 30, 30).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField8).addComponent(this.jTextField6).addComponent(this.jTextField7).addComponent(this.jTextField2))).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel3).addComponent(this.jLabel6, -2, 99, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField4, GroupLayout.Alignment.TRAILING, -1, 405, Short.MAX_VALUE).addComponent(this.jTextField3).addComponent(this.jTextField1)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField4, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField7, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField8, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField6, -2, -1, -2).addComponent(this.jLabel10)).addGap(0, 13, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("FilePath"));
        this.jLabel12.setText("Public Key:");
        this.jLabel13.setText("Private Key:");
        this.jLabel14.setText("Password:");
        this.jTextField10.setToolTipText("The name of the file on disk where the private key will be generated.");
        this.jTextField11.setToolTipText("The name of the file on disk where the public key will be generated.");
        this.jTextField5.setToolTipText("A Serial Number for the certificate. Used in conjunction with subject to identify the certificate. If regenerating the certificate, should be a unqiue value.");
        this.jTextField5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertificateGeneratorUI.this.jTextField5ActionPerformed(evt);
            }
        });
        this.jLabel11.setText("Serial Number:");
        this.jButton2.setText("...");
        this.jButton2.setToolTipText("");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertificateGeneratorUI.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("...");
        this.jButton3.setToolTipText("");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertificateGeneratorUI.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPasswordField1.setToolTipText("The password to use for the newly created certificate file. This password will later be needed when reading the private key, so keep it in a secure location.");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12).addComponent(this.jLabel13).addComponent(this.jLabel14).addComponent(this.jLabel11)).addGap(32, 32, 32).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextField5).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField11).addComponent(this.jTextField10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton2, -2, 16, -2).addComponent(this.jButton3, -2, 1, Short.MAX_VALUE))).addComponent(this.jPasswordField1, GroupLayout.Alignment.LEADING)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField11, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.jButton2, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField10, -2, -1, -2).addComponent(this.jLabel13).addComponent(this.jButton3, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.jPasswordField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField5, -2, -1, -2).addComponent(this.jLabel11)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 534, -2).addGap(0, 12, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(1, 1, 1).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int serialNumber;
        Certmgr mgr = new Certmgr();
        mgr.setRuntimeLicense("31534A395641315355425241315355425350454E434552544553543200000000000000000000000033463341473739450000423135333055424D465738440000");
        if (this.CheckFields().booleanValue()) {
            return;
        }
        try {
            serialNumber = Integer.parseInt(this.jTextField5.getText());
        }
        catch (NumberFormatException e2) {
            JOptionPane.showMessageDialog(this, "Serial Number must be an integer.");
            return;
        }
        this.BuildSubjectString();
        try {
            Files.delete(Paths.get(this.jTextField10.getText(), new String[0]));
        }
        catch (NoSuchFileException e2) {
        }
        catch (IOException x2) {
            JOptionPane.showMessageDialog(this, "Need permissions to overwrite already existing Private Key.");
        }
        try {
            mgr.config("UsePlatformSecurityAPI=False");
            mgr.setCertStoreType(2);
            mgr.setCertStorePassword(String.valueOf(this.jPasswordField1.getPassword()));
            mgr.setCertStore(this.jTextField10.getText());
        }
        catch (IPWorksSSLException ex2) {
            Logger.getLogger(CertificateGeneratorUI.class.getName()).log(Level.SEVERE, null, ex2);
            JOptionPane.showMessageDialog(this, ex2.getMessage());
        }
        try {
            mgr.createCertificate(this.certSubject, serialNumber);
            mgr.saveCertificate(this.jTextField11.getText());
            JOptionPane.showMessageDialog(this, "Public and Private key generation successful.");
        }
        catch (IPWorksSSLException ex3) {
            Logger.getLogger(CertificateGeneratorUI.class.getName()).log(Level.SEVERE, null, ex3);
            JOptionPane.showMessageDialog(this, "Error: " + ex3.getMessage());
        }
    }

    private void jTextField5ActionPerformed(ActionEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int returnVal = this.fileChooser1.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.fileChooser1.getSelectedFile();
            String filePath = file.getAbsolutePath();
            if (filePath.contains(".")) {
                this.jTextField11.setText(filePath);
            } else {
                this.jTextField11.setText(filePath + ".cer");
            }
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        int returnVal = this.fileChooser_pfx.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.fileChooser_pfx.getSelectedFile();
            String filePath = file.getAbsolutePath();
            if (filePath.contains(".")) {
                this.jTextField10.setText(filePath);
            } else {
                this.jTextField10.setText(filePath + ".pfx");
            }
        }
    }

    private void jTextField4ActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex2) {
            Logger.getLogger(CertificateGeneratorUI.class.getName()).log(Level.SEVERE, null, ex2);
        }
        catch (InstantiationException ex3) {
            Logger.getLogger(CertificateGeneratorUI.class.getName()).log(Level.SEVERE, null, ex3);
        }
        catch (IllegalAccessException ex4) {
            Logger.getLogger(CertificateGeneratorUI.class.getName()).log(Level.SEVERE, null, ex4);
        }
        catch (UnsupportedLookAndFeelException ex5) {
            Logger.getLogger(CertificateGeneratorUI.class.getName()).log(Level.SEVERE, null, ex5);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new CertificateGeneratorUI().setVisible(true);
            }
        });
    }
}

