/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import other.AAZ3;

public class CSVtoRedis {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importCSVtoRedis(String filePath, String serverAddress, String serverPort, String password, String[] logfiles) throws SQLException, IOException, ClassNotFoundException {
        String csvURL = "jdbc:csv:DataSource=" + filePath + ";IncludeFiles=.csv;Other=" + AAZ3.a1ef5b(new byte[]{12, 97, 64, 38});
        if (logfiles[0] != null) {
            csvURL = csvURL + ";Logfile=" + logfiles[0] + ";Verbosity=3";
        }
        String redisURL = "jdbc:redis:Server=" + serverAddress + ";Port=" + serverPort + ";" + (password == null ? "AuthScheme=NONE" : "Password=" + password) + ";Other=" + AAZ3.a1ef5b(new byte[]{21, 79, 46, 83});
        if (logfiles[1] != null) {
            redisURL = redisURL + ";Logfile=" + logfiles[1] + ";Verbosity=3";
        }
        Connection csvConn = DriverManager.getConnection(csvURL);
        int batchSize = 1000;
        int offset = 0;
        int resultsRead = 0;
        do {
            resultsRead = 0;
            Statement csvStat = csvConn.createStatement();
            ResultSet csvResults = csvStat.executeQuery("SELECT * FROM nw_redis LIMIT " + batchSize + " OFFSET " + offset);
            offset += batchSize;
            ArrayList<Key> list = new ArrayList<Key>();
            while (csvResults.next()) {
                Key key = new Key();
                key.redisKey = csvResults.getObject("RedisKey").toString();
                key.value = csvResults.getObject("Value").toString().replace("'", "''");
                key.valueIndex = csvResults.getObject("ValueIndex").toString();
                key.redisType = csvResults.getObject("RedisType").toString();
                list.add(key);
                ++resultsRead;
            }
            csvResults.close();
            Class.forName("cdata.jdbc.redis.RedisDriver");
            Connection redisConn = DriverManager.getConnection(redisURL);
            String query = "INSERT INTO Keys (RedisKey, Value, ValueIndex, RedisType) VALUES (?, ?, ?, ?)";
            PreparedStatement stmt = redisConn.prepareStatement(query);
            redisConn.setAutoCommit(false);
            for (Key key : list) {
                if (!key.redisType.equalsIgnoreCase("hash")) break;
                stmt.clearParameters();
                stmt.setString(1, key.redisKey);
                stmt.setString(2, key.value);
                stmt.setString(3, key.valueIndex);
                stmt.setString(4, key.redisType);
                stmt.addBatch();
            }
            stmt.clearParameters();
            int[] r2 = new int[]{};
            try {
                r2 = stmt.executeBatch();
            }
            catch (Exception ex2) {
                System.out.println(ex2.getMessage());
                System.out.println(ex2.getStackTrace());
            }
            finally {
                redisConn.commit();
            }
        } while (resultsRead >= batchSize);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3 || args.length > 8) {
            throw new Exception("Usage: java -jar CSVtoRedis.jar path_to_csv_files redis_server_address redis_server_port [redis_password] [-clog csv_log_path] [-rlog redis_log_path]");
        }
        String[] logfiles = new String[]{null, null};
        if ((args.length == 5 || args.length == 7) && args[3].toLowerCase().equals("-clog")) {
            logfiles[0] = args[4];
        } else if ((args.length == 6 || args.length == 8) && args[4].toLowerCase().equals("-clog")) {
            logfiles[0] = args[5];
        }
        if (args.length == 5 && args[3].toLowerCase().equals("-rlog")) {
            logfiles[1] = args[4];
        } else if (args.length == 6 && args[4].toLowerCase().equals("-rlog")) {
            logfiles[1] = args[5];
        } else if (args.length == 7 && args[5].toLowerCase().equals("-rlog")) {
            logfiles[1] = args[6];
        } else if (args.length == 8 && args[6].toLowerCase().equals("-rlog")) {
            logfiles[1] = args[7];
        }
        CSVtoRedis.importCSVtoRedis(args[0], args[1], args[2], args.length > 3 ? args[3] : null, logfiles);
    }
}

